#include "Scena.h"
#include <cstdio>
#include <fstream>
#include <sstream>
#include <vector>


/*
MODEL CLASS
*/
CModel::CModel()
	:typTrojkatow(TYPTROJKATA_NIEPOPRAWNY)
{
}


/*
SCENA CLASS
*/
CScena::~CScena()
{
	this->Wyczysc();
}


void CScena::Wyczysc(void)
{
	CModelWsk modelWsk;
	while(!this->modele.empty())
	{
		modelWsk = this->modele.back();
		this->modele.pop_back();
		delete modelWsk;
	}
	this->wierzcholki.clear();
	this->normalne.clear();
	this->wspolrzedneTekstur.clear();
}


void CScena::Wczytaj(const std::string& nazwaPliku)
{
	using namespace std;

	//Usunicie poprzednich danych jeeli takie istniay
	this->Wyczysc();
	//Otwarcie pliku
	ifstream plik;
	plik.open(nazwaPliku.c_str());
	if (!plik.is_open())
		throw WyjatekOBJ("Nie mona odczyta pliku", nazwaPliku, 0);

	string linia;
	unsigned int nrLinii = 0;
	int result;
	vector<string> kolumny;
	SWierzcholek4 wspolrzedne4;
	SWierzcholek3 wspolrzedne3;
	SWierzcholek2 wspolrzedne2;
	
	STrojkat trojkat;
	ETypTrojkata typWierzcholka1, typWierzcholka2, typWierzcholka3;
	CModelWsk modelWsk;// = new CModel();

	while (!plik.eof())
	{
		nrLinii++;
		getline(plik, linia);
		//Pominicie komentarzy
		if(linia[0] == '#')
			continue;

		kolumny.clear();
		//Usunicie spacji i podzia linii
		this->Podziel(linia, kolumny);

		//Pominicie pustych linii
		if(kolumny.size() == 0)
			continue;

		//Wsprzdne wierzchoka
		if(kolumny[0] == "v"){
			result = sscanf(linia.c_str(), "v%f%f%f%f", &wspolrzedne4.x, &wspolrzedne4.y, &wspolrzedne4.z, &wspolrzedne4.w);
			switch(result){
				case 2:
					wspolrzedne4.z = 0.0f;
				case 3:
					wspolrzedne4.w = 1.0f;
				case 4:
					this->wierzcholki.push_back(wspolrzedne4);
					continue;
				default:
					throw WyjatekOBJ("Za liczba wsprzdnych wierzchoka", nazwaPliku, nrLinii);
			}
		}
		//Normalna wierzchoka
		if(kolumny[0] == "vn"){
			result = sscanf(linia.c_str(), "vn%f%f%f", &wspolrzedne3.x, &wspolrzedne3.y, &wspolrzedne3.z);
			if(result != 3)
				throw WyjatekOBJ("Za liczba wsprzdnych normalnej", nazwaPliku, nrLinii);
			this->normalne.push_back(wspolrzedne3);
			continue;
		}
		//Wsprzdne tekstury
		if(kolumny[0] == "vt"){
			result = sscanf(linia.c_str(), "vt%f%f", &wspolrzedne2.x, &wspolrzedne2.y);
			if(result != 2)
				throw WyjatekOBJ("Za liczba wsprzdnych tekstury", nazwaPliku, nrLinii);
			this->wspolrzedneTekstur.push_back(wspolrzedne2);
			continue;
		}
		//Powierzchnia (trjkt)
		if(kolumny[0] == "f"){
			if(kolumny.size() != 4){
				throw WyjatekOBJ("Implementacja obsuguje tylko powierzchnie trjktne", nazwaPliku, nrLinii);
			}
			//Jeeli plik nie definiuje nazwy obiektu (prefiks "o") to naley go utworzy
			if(this->modele.empty()){
				modelWsk = new CModel();
				this->modele.push_back(modelWsk);
			}
			typWierzcholka1 = this->OdczytajIndeksy(kolumny[1], trojkat.w1, trojkat.t1, trojkat.n1);
			typWierzcholka2 = this->OdczytajIndeksy(kolumny[2], trojkat.w2, trojkat.t2, trojkat.n2);
			typWierzcholka3 = this->OdczytajIndeksy(kolumny[3], trojkat.w3, trojkat.t3, trojkat.n3);
			if(typWierzcholka1 != TYPTROJKATA_NIEPOPRAWNY &&
			   typWierzcholka1 == typWierzcholka2 &&
			   typWierzcholka2 == typWierzcholka3)
			{
				//Sprawdzenie czy zgadza si z ju odczytanymi wierzchokami
				if(modelWsk->typTrojkatow == TYPTROJKATA_NIEPOPRAWNY)
					modelWsk->typTrojkatow = typWierzcholka1;
				else
					if(modelWsk->typTrojkatow != typWierzcholka1)
						throw WyjatekOBJ("Wszystkie trjkaty obiektu musz by tego samego rodzaju - W, W/T, W//N lub W/T/N", nazwaPliku, nrLinii);

				//Pliki *.obj uywaj indeksowania od 1, a wektory indeksowane s od 0
				trojkat.w1 -= 1;
				trojkat.w2 -= 1;
				trojkat.w3 -= 1;
				trojkat.t1 -= 1;
				trojkat.t2 -= 1;
				trojkat.t3 -= 1;
				trojkat.n1 -= 1;
				trojkat.n2 -= 1;
				trojkat.n3 -= 1;
				modelWsk->trojkaty.push_back(trojkat);
				continue;
			}
			throw WyjatekOBJ("Nieprawidowy format powierzchni", nazwaPliku, nrLinii);
		}
		//Nazwa obiektu
		if(kolumny[0] == "o"){
			if(kolumny.size() != 2){
				throw WyjatekOBJ("Brak nazwy obiektu lub nazwa zawiera spacje", nazwaPliku, nrLinii);
			}
			//Od tego miejsca zaczyna si nowy obiekt
			modelWsk = new CModel();
			modelWsk->nazwa = kolumny[1];
			this->modele.push_back(modelWsk);
		}
	} //while(!plik.eof())
	plik.close();
}


void CScena::Podziel(const std::string& str, std::vector<std::string>& fragmenty, const char* c) const
{
	using namespace std;
	//Pominicie wiodcych znakw podziau
	string::size_type ostatnie = str.find_first_not_of(c, 0);
	//Znalezienie pierwszego znaku podziau
	string::size_type pozycja = str.find_first_of(c, ostatnie);

	while(pozycja != string::npos || ostatnie != string::npos)
	{
		//Dodanie fragmentu tekstu do wektora
		fragmenty.push_back(str.substr(ostatnie, pozycja - ostatnie));
		//Znalezienie pocztku kolejnego tekstu
		ostatnie = str.find_first_not_of(c, pozycja);
		//Znalezienie znaku podziau nastpujcego po znalezionym fragmencie tekstu
		pozycja = str.find_first_of(c, ostatnie);
	}
}


ETypTrojkata CScena::OdczytajIndeksy(const std::string& str, GLuint& vertex, GLuint& texture, GLuint& normal) const
{
	using namespace std;
	const char* buffer = str.c_str();
	int result;

	//Jeeli seperator "//" zosta znaleziony to zapisany jest tylko indeks wierzchoka i jego normalnej
	//Format: W//N
	if(strstr(buffer, "//")){
		result = sscanf(buffer, "%u//%u", &vertex, &normal);
		if(result != 2)
			return TYPTROJKATA_NIEPOPRAWNY;
		return TYPTROJKATA_WN;
	}
	
	result = sscanf(buffer, "%u/%u/%u", &vertex, &texture, &normal);	
	switch(result){
		case 1:
			//Format: W
			return TYPTROJKATA_W;
		case 2:
			//TODO: sprawdzic czy T/N tez!!!		
			return TYPTROJKATA_WT;
		case 3:
			//Format: W/T/N
			return TYPTROJKATA_WTN;
		default:
			//Nieprawidowy format
			return TYPTROJKATA_NIEPOPRAWNY;
	}
}
